/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.util;

import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ColorUtil {
    private ColorUtil() {
    }

    public static Color withAlpha(@NotNull Color c2, float alpha) {
        int a2 = Math.max(Math.min(255, (int)(alpha * 255.0f)), 0);
        return new Color(c2.getRed(), c2.getGreen(), c2.getBlue(), a2);
    }

    public static String toString(@Nullable Color c2) {
        if (c2 == null) {
            return "null";
        }
        return String.format("Color[%d,%d,%d,%d]", c2.getRed(), c2.getGreen(), c2.getBlue(), c2.getAlpha());
    }

    public static void RGBtoHSL(int r2, int g2, int b2, float @NotNull [] hsl) {
        float s2;
        float h2;
        float maxComponent;
        float minComponent;
        if (r2 < 0) {
            r2 = 0;
        } else if (r2 > 255) {
            r2 = 255;
        }
        if (g2 < 0) {
            g2 = 0;
        } else if (g2 > 255) {
            g2 = 255;
        }
        if (b2 < 0) {
            b2 = 0;
        } else if (b2 > 255) {
            b2 = 255;
        }
        float componentR = (float)r2 / 255.0f;
        float componentG = (float)g2 / 255.0f;
        float componentB = (float)b2 / 255.0f;
        if (componentR > componentG) {
            minComponent = componentG;
            maxComponent = componentR;
        } else {
            minComponent = componentR;
            maxComponent = componentG;
        }
        if (componentB > maxComponent) {
            maxComponent = componentB;
        }
        if (componentB < minComponent) {
            minComponent = componentB;
        }
        float deltaMax = maxComponent - minComponent;
        float l2 = (maxComponent + minComponent) / 2.0f;
        if (deltaMax - 0.01f <= 0.0f) {
            h2 = 0.0f;
            s2 = 0.0f;
        } else {
            if (l2 < 0.5f) {
                assert (maxComponent + minComponent != 0.0f);
                s2 = deltaMax / (maxComponent + minComponent);
            } else {
                s2 = deltaMax / (2.0f - maxComponent - minComponent);
            }
            assert (deltaMax > 0.0f);
            float deltaR = ((maxComponent - componentR) / 6.0f + deltaMax / 2.0f) / deltaMax;
            float deltaG = ((maxComponent - componentG) / 6.0f + deltaMax / 2.0f) / deltaMax;
            float deltaB = ((maxComponent - componentB) / 6.0f + deltaMax / 2.0f) / deltaMax;
            h2 = componentR == maxComponent ? deltaB - deltaG : (componentG == maxComponent ? 0.33333334f + deltaR - deltaB : 0.6666667f + deltaG - deltaR);
            if (h2 < 0.0f) {
                h2 += 1.0f;
            }
            if (h2 > 1.0f) {
                h2 -= 1.0f;
            }
        }
        hsl[0] = h2;
        hsl[1] = s2;
        hsl[2] = l2;
    }

    public static void HSLtoRGB(float h2, float s2, float l2, int @NotNull [] rgb) {
        int b2;
        int g2;
        int r2;
        if (h2 < 0.0f) {
            h2 = 0.0f;
        } else if (h2 > 1.0f) {
            h2 = 1.0f;
        }
        if (s2 < 0.0f) {
            s2 = 0.0f;
        } else if (s2 > 1.0f) {
            s2 = 1.0f;
        }
        if (l2 < 0.0f) {
            l2 = 0.0f;
        } else if (l2 > 1.0f) {
            l2 = 1.0f;
        }
        if (s2 - 0.01f <= 0.0f) {
            r2 = (int)(l2 * 255.0f);
            g2 = (int)(l2 * 255.0f);
            b2 = (int)(l2 * 255.0f);
        } else {
            float y2 = l2 < 0.5f ? l2 * (1.0f + s2) : l2 + s2 - s2 * l2;
            float x2 = 2.0f * l2 - y2;
            r2 = (int)(255.0f * ColorUtil.hue2RGB(x2, y2, h2 + 0.33333334f));
            g2 = (int)(255.0f * ColorUtil.hue2RGB(x2, y2, h2));
            b2 = (int)(255.0f * ColorUtil.hue2RGB(x2, y2, h2 - 0.33333334f));
        }
        rgb[0] = r2;
        rgb[1] = g2;
        rgb[2] = b2;
    }

    private static float hue2RGB(float v1, float v2, float vH) {
        if (vH < 0.0f) {
            vH += 1.0f;
        }
        if (vH > 1.0f) {
            vH -= 1.0f;
        }
        if (6.0f * vH < 1.0f) {
            return v1 + (v2 - v1) * 6.0f * vH;
        }
        if (2.0f * vH < 1.0f) {
            return v2;
        }
        if (3.0f * vH < 2.0f) {
            return v1 + (v2 - v1) * (0.6666667f - vH) * 6.0f;
        }
        return v1;
    }
}

